import { StarXpandCommand } from "star-io10-web";

export class LabelSample14_For203dpiAnd300dpi_ExpirationLabelJP_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        // Change the printable area setting for this layout according to the printer resolution.
        // 48.0 for 203dpi, 34.0 for 300dpi
        .settingPrintableArea(48.0)
        //.settingPrintableArea(34.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            // モデルにより対応する文字エンコーディング指定APIが異なります。
            // 下記ページのSupported Modelを参照し、ご利用のモデルが対応するAPIを使用してください。
            // https://www.star-m.jp/products/s_print/sdk/star-io10-web/manual/ja/api-reference/star-xpand-command/printer-builder/style-cjk-character-priority.html
            .styleCjkCharacterPriority([
              StarXpandCommand.Printer.CjkCharacterType.Japanese,
            ])
            // https://www.star-m.jp/products/s_print/sdk/star-io10-web/manual/ja/api-reference/star-xpand-command/printer-builder/style-second-priority-character-encoding.html
            //.styleSecondPriorityCharacterEncoding(CharacterEncodingType.Japanese)

            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleBold(true)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("${remarks}\n"),
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleAlignment(StarXpandCommand.Printer.Alignment.Left)
                .actionPrintText("${note}\n" + "　　消費期限\n"),
            )
            .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
            .styleMagnification(
              new StarXpandCommand.MagnificationParameter(2, 2),
            )
            .actionPrintText("${expiry_date}\n")
            .styleMagnification(
              new StarXpandCommand.MagnificationParameter(1, 1),
            )
            .actionPrintText(
              "${shop_name}\n" + "${address}\n" + "TEL ${telephone_number}\n",
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );

    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "remarks" : "＜要冷蔵＞",
    "note" : "10℃以下で保存し、本日中にお召し上がり下さい。",
    "expiry_date" : "2010.1.25",
    "shop_name" : "スターショップ\\n静岡　太郎",
    "address" : "XXX県XXX市XXX町123-1",
    "telephone_number" : "1234-567-890"
}`,
    );
  }
}
